/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.container;

import com.tiviacz.pizzacraft.blockentity.PizzaBlockEntity;
import com.tiviacz.pizzacraft.container.slots.UnaccessibleSlot;
import com.tiviacz.pizzacraft.init.ModMenuTypes;
import com.tiviacz.pizzacraft.init.PizzaLayers;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class PizzaMenu
extends AbstractContainerMenu {
    public Inventory inv;
    public PizzaBlockEntity blockEntity;

    public PizzaMenu(int windowID, Inventory inv, FriendlyByteBuf data) {
        this(windowID, inv, PizzaMenu.getBlockEntity(inv, data));
    }

    public PizzaMenu(int windowID, Inventory inv, BlockEntity tile) {
        super((MenuType)ModMenuTypes.PIZZA.get(), windowID);
        this.inv = inv;
        this.blockEntity = (PizzaBlockEntity)tile;
        if (this.blockEntity.isRaw()) {
            this.addIngredientsSlotsRaw();
        } else {
            this.addIngredientsSlots();
        }
        this.addPlayerInventoryAndHotbar(inv);
    }

    public void addPlayerInventoryAndHotbar(Inventory inv) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)inv, x + y * 9 + 9, 8 + x * 18, 76 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inv, x, 8 + x * 18, 134));
        }
    }

    public void addIngredientsSlotsRaw() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.getInventory(), j + i * 3, 62 + j * 18, 10 + i * 18){

                    public int m_5866_(@Nonnull ItemStack stack) {
                        return PizzaLayers.getMaxStackSizeForStack(stack);
                    }
                });
            }
        }
    }

    public void addIngredientsSlots() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.m_38897_((Slot)new UnaccessibleSlot((IItemHandler)this.blockEntity.getInventory(), j + i * 3, 62 + j * 18, 10 + i * 18));
            }
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < 9 ? !this.m_38903_(itemstack1, 9, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, 9, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    private static PizzaBlockEntity getBlockEntity(Inventory inv, FriendlyByteBuf data) {
        Objects.requireNonNull(inv, "inv cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity blockEntity = inv.f_35978_.f_19853_.m_7702_(data.m_130135_());
        if (blockEntity instanceof PizzaBlockEntity) {
            return (PizzaBlockEntity)blockEntity;
        }
        throw new IllegalStateException("Block entity is not correct! " + blockEntity);
    }
}

